[Setup]
;-- Main Setup Information
 AppName                  = SQL-Exchange Server
 AppVerName               = SQL-Exchange Server 1.0.1.8
 AppCopyright             = Copyright  1995-2004 Ingenuity Software, Corp.
 DefaultDirName           = {pf}\Ingenuity Software, Corp\SQL-Exchange\Server
 DefaultGroupName         = Ingenuity\SQL-Exchange Server
 UninstallDisplayIcon     = {app}\SQLEServer.Exe
 UninstallStyle           = Modern
 WizardImageFile          = Resources\LgSetup.bmp
 WizardSmallImageFile     = Resources\SmSetup.bmp
 PrivilegesRequired       = PowerUser
 Uninstallable            = Yes
 AppMutex                 = SQL-Exchange Server
 LicenseFile              = Resources\EULA.txt
 Compression              = ZIP/9
 OutputBaseFilename       = Setup
;UninstallLogMode         = OverWrite
 UninstallRestartComputer = Yes
 DisableStartupPrompt     = Yes
 DirExistsWarning         = No

;-- Windows 2000 & XP (Support Dialog)
 AppPublisher    = Ingenuity Software, Corp.
 AppPublisherURL = http://www.IngenuityERP.com/
 AppUpdatesURL   = http://www.IngenuityERP.com/
 AppVersion      = 1.0.1.8

[Files]
 Source: "..\Debug\SQLEServer.Exe";           DestDir: "{app}"; Flags: IgnoreVersion RestartReplace;
 Source: "ServiceCtl\Release\ServiceCtl.Exe"; DestDir: "{app}"; Flags: IgnoreVersion;

 Source: "Resources\EULA.txt";                DestDir: "{app}"; Flags: IgnoreVersion;
 Source: "Resources\OpenDlg.ico";             DestDir: "{app}"; Flags: IgnoreVersion;
 Source: "Resources\Start.ico";               DestDir: "{app}"; Flags: IgnoreVersion;
 Source: "Resources\Stop.ico";                DestDir: "{app}"; Flags: IgnoreVersion;
 Source: "Resources\OpenCon.ico";             DestDir: "{app}"; Flags: IgnoreVersion;

 Source: "Libraries\NSWFL.Dll";               DestDir: "{app}"; Flags: RestartReplace;
 Source: "Libraries\NASCCL.Dll";              DestDir: "{app}"; Flags: RestartReplace;

[Icons]
 Name: "{group}\Open Server";    Filename: "{app}\ServiceCtl.Exe";  WorkingDir: "{app}"; Parameters: "/openmaindialog"; IconFilename: "{app}\OpenDlg.ico"
 Name: "{group}\Open Console";   Filename: "{app}\ServiceCtl.Exe";  WorkingDir: "{app}"; Parameters: "/openconsole";    IconFilename: "{app}\OpenCon.ico"
 Name: "{group}\Start Service";  Filename: "{app}\ServiceCtl.Exe";  WorkingDir: "{app}"; Parameters: "/start";          IconFilename: "{app}\Start.ico"
 Name: "{group}\Stop Service";   Filename: "{app}\ServiceCtl.Exe";  WorkingDir: "{app}"; Parameters: "/stop";           IconFilename: "{app}\Stop.ico"

[Dirs]
 Name: "{app}\Logs"

[Registry]
 Root: HKLM; Subkey: "Software\Ingenuity Software, Corp.\SQL-Exchange\Server"; Flags: UninsDeleteKey

 Root: HKLM; Subkey: "Software\Ingenuity Software, Corp.\SQL-Exchange\Server"; ValueName: "Path";              ValueType: String; ValueData: "{app}";           Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\Ingenuity Software, Corp.\SQL-Exchange\Server"; ValueName: "SessionLogDir";     ValueType: String; ValueData: "{app}\Logs";      Flags: CreateValueIfDoesntExist;

 Root: HKLM; Subkey: "Software\Ingenuity Software, Corp.\SQL-Exchange\Server"; ValueName: "AuthString";        ValueType: String; ValueData: "trIeSPiUhouDlUwRLe5hie2H5awRoupiaDi8zI0fo3Y7u6R703r7e6rLacrouChi";
 Root: HKLM; Subkey: "Software\Ingenuity Software, Corp.\SQL-Exchange\Server"; ValueName: "BaseCommKey";       ValueType: String; ValueData: "6riupiekieB8uphiuspi0tr6azl2piAth6us6ieko2zoap2818UviapHlEvo5joe";

 Root: HKLM; Subkey: "Software\Ingenuity Software, Corp.\SQL-Exchange\Server"; ValueName: "ClientFilesTemp";   ValueType: String; ValueData: "{app}\CFTemp";

 Root: HKLM; Subkey: "Software\Ingenuity Software, Corp.\SQL-Exchange\Server"; ValueName: "SQLIndexDatabase";  ValueType: String; ValueData: "WebPortalIndex";  Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\Ingenuity Software, Corp.\SQL-Exchange\Server"; ValueName: "SQLIndexDriver";    ValueType: String; ValueData: "{{SQL Server}";   Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\Ingenuity Software, Corp.\SQL-Exchange\Server"; ValueName: "SQLIndexPassword";  ValueType: String; ValueData: "";                Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\Ingenuity Software, Corp.\SQL-Exchange\Server"; ValueName: "SQLIndexServer";    ValueType: String; ValueData: "";                Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\Ingenuity Software, Corp.\SQL-Exchange\Server"; ValueName: "SQLIndexUserID";    ValueType: String; ValueData: "sa";              Flags: CreateValueIfDoesntExist;

 Root: HKLM; Subkey: "Software\Ingenuity Software, Corp.\SQL-Exchange\Server"; ValueName: "SQLCustDriver";     ValueType: String; ValueData: "{{SQL Server}";   Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\Ingenuity Software, Corp.\SQL-Exchange\Server"; ValueName: "SQLCustPassword";   ValueType: String; ValueData: "";                Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\Ingenuity Software, Corp.\SQL-Exchange\Server"; ValueName: "SQLCustServer";     ValueType: String; ValueData: "";                Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\Ingenuity Software, Corp.\SQL-Exchange\Server"; ValueName: "SQLCustUserID";     ValueType: String; ValueData: "sa";              Flags: CreateValueIfDoesntExist;

 Root: HKLM; Subkey: "Software\Ingenuity Software, Corp.\SQL-Exchange\Server"; ValueName: "ListenPort";        ValueType: Dword;  ValueData: "6632";            Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\Ingenuity Software, Corp.\SQL-Exchange\Server"; ValueName: "MaxConnections";    ValueType: Dword;  ValueData: "10";              Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\Ingenuity Software, Corp.\SQL-Exchange\Server"; ValueName: "TCPLoopDelay";      ValueType: Dword;  ValueData: "1";               Flags: CreateValueIfDoesntExist;

[Run]
 Filename: "{app}\ServiceCtl.EXE"; Parameters: "/install";
 Filename: "{app}\ServiceCtl.EXE"; Parameters: "/start";

[UninstallRun]
 Filename: "{app}\ServiceCtl.EXE"; Parameters: "/delete"; RunOnceId: "DeleteService"; MinVersion: 0, 4.0

